![[Pasted image 20250708183725.png]]


![[Pasted image 20250708183740.png]]


Datagram (DTLS) - Difference being it uses UDP port 443 for faster data transfer unlike TCP 443 that TLS uses. 
![[Pasted image 20250708184028.png]]

### SSL and TLS Protocols – Summary

---

#### 1. Introduction and Evolution

- **SSL (Secure Sockets Layer):**
    - Developed by Netscape in the 1990s for secure web transactions.
    - Last version (3.0) released in 1996 as an internet-draft.
- **TLS (Transport Layer Security):**
    - Adopted and standardized by IETF in 1999 as the successor to SSL.
    - Current version is TLS 1.3 (RFC 8446, August 2018).
    - Also referred to as SSL version 3.1.
- **Usage:**
    - Widely used in web browsing, email, VoIP, and remote-access VPNs.
    - Despite the name, modern "SSL VPNs" use TLS, not SSL.

---

#### 2. Authentication and Protocol Operation

- **Authentication:**
    - Can be one-way (server authentication) or mutual (client and server authentication).
    - Certificate-based, relying on trusted Certificate Authorities (CAs).
- **Protocol Phases:**
    - **Session Establishment:**
        - Negotiates parameters, authenticates peers, exchanges keys.
    - **Data Transfer:**
        - Provides protected, encrypted communications.
- **Session IDs:**
    - Each session has a unique ID for resumption and identification.
    - Sessions can be resumed to avoid renegotiation if interrupted.

---

#### 3. TLS vs DTLS

- **TLS (Transport Layer Security):**
    - Runs over TCP; provides reliable, encrypted connections.
    - Used for most web applications and VPNs.
- **DTLS (Datagram Transport Layer Security):**
    - Runs over UDP; designed for real-time applications.
    - Reduces latency and improves performance for voice/video.
    - Enables low-latency data paths by avoiding VPN-layer retransmissions.
    - Cisco Secure Client prefers DTLS for SSL VPNs, with automatic fallback to TLS if needed.
    - Requires firewall to allow both UDP 443 and TCP 443.
    - Only used in SSL VPNs, not IPsec.

---

#### 4. SSL/TLS Session Setup and Key Management

**Summary** - 
![[Pasted image 20250708185409.png]]
- **Four Phases:** 
    1. **Client-Server Capability Negotiation:**
        - Exchange hello messages and propose authentication/encryption algorithms (e.g., RSA, DH).
        - ![[Pasted image 20250708184454.png]]
    2. **Server Certificate & Key Exchange:**
        - Server sends its certificate; client initiates protection using server’s public key.
        - ![[Pasted image 20250708184527.png]]
        - ![[Pasted image 20250708184609.png]]
        - ![[Pasted image 20250708184655.png]]
        - ![[Pasted image 20250708184624.png]]
        - ![[Pasted image 20250708184725.png]]
        - ![[Pasted image 20250708184737.png]]

    3. **Client Certificate (if required) & Key Exchange:**
        - Client provides its certificate for mutual authentication, calculates session key.
        - ![[Pasted image 20250708184817.png]]
        - ![[Pasted image 20250708184843.png]]
        - ![[Pasted image 20250708184913.png]]
        - Client sends server a finished message encrypted with secret key:  ![[Pasted image 20250708184933.png]]
        - After this, server sends client a finished message - ![[Pasted image 20250708185041.png]]

    4. **Finish/Data Transfer:**
        - Session keys exchanged, encrypted communication begins.
        - ![[Pasted image 20250708185109.png]]
        - ![[Pasted image 20250708185124.png]]
- **Session ID:**
    - Used for session resumption if needed without re-negotiation. 

---

#### 5. SSL Server and Client Authentication

- **Server Authentication:**
    - Server presents a certificate signed by a trusted CA.
    - Client verifies the certificate before proceeding.
    - Ensures secure connections to legitimate servers.
- **Client Authentication (optional):**
    - Server can request a client certificate.
    - Used for verifying users in remote-access VPNs.
    - Client proves possession of the private key associated with the certificate.

---

#### 6. SSL/TLS Transmission Protection

![[Pasted image 20250708192826.png]]

- **SSL/TLS Record Protocol:**
    - Breaks application data into protected records (up to 16,384 bytes each).
    - Each record includes:
        - Header
        - Data portion
        - [[HMAC]] (for integrity)
    - Data and HMAC are encrypted; optional compression.
- **Record Types:**
    - Handshake, cipher change, alert, and data exchange.
- **Phases:**
    - **Handshake:**
        - Authentication and key exchange using public-key cryptography (e.g., (EC)DHE, PSK).
    - **Application Data Transfer:**
        - Confidentiality via AEAD encryption.
        - Integrity via Message Authentication Code (MAC).

---

#### 7. Key Points and Best Practices

- SSL is largely obsolete; TLS is the current standard for secure communications.
- Most modern applications and VPNs use TLS, with DTLS preferred for real-time applications.
- Mutual authentication is available and often used in VPN scenarios.
- Ensure both UDP 443 and TCP 443 are open for optimal DTLS/TLS operation.
- Cisco Secure Client can automatically fall back to TLS if DTLS is not available.

---

**Note:**

- SSL/TLS protocols are foundational for secure communications, and understanding their phases, authentication mechanisms, and transport protocols (TCP/UDP) is crucial for both web security and VPN deployment.